<%@page contentType="text/html;charset=utf-8"%>
<!DOCTYPE html >
<head>
<meta charset="utf-8"/>
<title>IBSheet7-Product</title>

<script type="text/javascript" src="../Chart/jquery-1.7.2.min.js"></script>
<script type="text/javascript" src="../js/common.js"></script>
<script type="text/javascript" src="../Chart/highcharts/highcharts.js"></script>
<script type="text/javascript" src="../Chart/ibchart.js"></script>
<script type="text/javascript" src="../Chart/ibchartinfo.js"></script>


<script type="text/javascript">
	function init_chart(){
		var opt = {
			param : {
				SERIES_CNT:1
			},
			append: false,
			sync:true
		}
		createIBChart("myChart", "myChart", {
			width: "100%",
			height: "275px"
		});

		DoSearch(myChart, "practice3_data.jsp", opt);
	}
	function doAction(str){
		switch(str){
			case 'search':
			var a = "";
			switch(document.getElementById("sel_XAlign").value){
				case "LEFT":
				a = "left";
				break;
				case "CENTER":
				a = "center";
				break;
				case "RIGHT":
				a = "right";
				break;
			}

			myChart.setOptions({
				xAxis: [{
					title:{
						enabled:true,
						text: document.getElementById("txt_XTitle").value,
						align : "middle"
					},
					labels:{
						enabled:true,
						align:a,
						rotation:eval(document.getElementById("txt_XRotation").value),
						step:1
					}
				}]
			},{
				append: true,
				redraw: true
			});
			break;

			case 'search2':
			var booleanOpp = false;
			if(document.getElementById("sel_YOpposite").value=="RIGHT") {booleanOpp = true;
			}

			myChart.setOptions({
				yAxis: [{
					title:{
						enabled:true,
						text:document.getElementById("txt_YTitle").value,
						align: "middle"
					},
					opposite:booleanOpp
				}]
			},{
				append: true,
				redraw: true
			});
			break;

			case 'search3':
			myChart.setOptions({
				xAxis:[{
					gridLineColor:document.getElementById("txt_YGridColor").value,
					lineColor:document.getElementById("txt_YAxisColor").value
				}],
				yAxis:[{
					gridLineColor:document.getElementById("txt_YGridColor").value,
					lineColor:document.getElementById("txt_YAxisColor").value
				}]
			},{
				append: true,
				redraw: true
			});
			break;
		}
	}

	function DoSearch(chart,url,subparam){
		$.ajax({
			type: 'post'
			, async: subparam.sync
			, dataType:"text"
			, url: url
			, data: subparam.param
			, beforeSend: function() {

			}
			, success: function(xml) {
				chart.loadSearchData(xml,subparam);
			}
			, error: function(data, status, err) {
				alert('서버와의 통신이 실패했습니다.');
			}
			,complete:function(jqXHR,textStatus){

			}
		});
	}
</script>

</head>

<body onload="init_chart()">

	<div class="page_title">
		<span><a class="closeDepth" href="#">closeDepth</a></span>
		<span class="title color_sheet">차트개발 실습  > <b>X,Y축 설정</b></span>
	</div>

	<div class="main_content">
		<div class="exp_product">
			축(Axis)에 관련된 설정을 변경해 본다.
		</div>

		<p class="subtit_chart">축(Axis) 설정</p>
		<div class="ib_function2 border_chart">
			<table class="ib_column2">
				<tr>
					<th class="tit">X축 타이틀</th>
					<td class="r20">
						<input type="text" id="txt_XTitle" class="inputbox2"  value="X Axis Title">
					</td>
					<th class="tit">X축 레이블 정렬 및 기울임</th>
					<td class="r20">
						<select class="input_all" id="sel_XAlign" title="정렬">
							<option value="RIGHT" >오른쪽</option>
							<option value="CENTER" >가운데</option>
							<option value="LEFT" >왼쪽</option>
						</select>
						&nbsp;
						<input type="text" id="txt_XRotation" class="inputbox2" style="width:25px" maxlength="3"  value="-45">
						<th class="tit"></th>
						<td class="r20">
							<a href="javascript:doAction('search');" class="f2_btn_white btn_chart">확인</a>
						</td>
					</td>
				</tr>
				<tr>
					<th class="tit">Y축 타이틀</th>
					<td class="r20">
						<input type="text" id="txt_YTitle" class="inputbox2"  value="Y Axis Title">
					</td>
					<th class="tit">Y축 위치</th>
					<td class="r20">
						<select class="input_all" id="sel_YOpposite" title="정렬">
							<option value="LEFT" >왼쪽</option>
							<option value="RIGHT" >오른쪽</option>
						</select>

						<th class="tit"></th>
						<td class="r20">
							<a href="javascript:doAction('search2');" class="f2_btn_white btn_chart">확인</a>
						</td>
					</td>
				</tr>
				<tr>
					<th class="tit">격자 색상</th>
					<td class="r20">
						<input type="text" id="txt_YGridColor" class="inputbox2"  value="#FF0000">
					</td>
					<th class="tit">축선 색상</th>
					<td class="r20">
						<input type="text" id="txt_YAxisColor" class="inputbox2"  value="#0000FF">

						<th class="tit"></th>
						<td class="r20">
							<a href="javascript:doAction('search3');" class="f2_btn_white btn_chart">확인</a>
						</td>
					</td>
				</tr>
			</table>
		</div>
		<p class="subtit_chart">IB Chart</p>
		<br/>
		<div class="ib_product">
			<div id="myChart"></div>
		</div>
	</div>
    <!--main_content-->
</body>
</html>
